%define module_name MooX-Const
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Devel/StrictMode.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Module/Metadata.pm) perl(Moo.pm) perl(Moose.pm) perl(Pod/Coverage/TrustPod.pm) perl(Scalar/Util.pm) perl(Test/CleanNamespaces.pm) perl(Test/EOL.pm) perl(Test/Fixme.pm) perl(Test/Kwalitee.pm) perl(Test/MinimumVersion.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(Test/NoTabs.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Types/Const.pm) perl(Types/Standard.pm) perl(if.pm) perl(lib.pm) perl(namespace/autoclean.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.6.2
Release: alt1
Summary: Syntactic sugar for constant and write-once Moo attributes
Group: Development/Perl
License: artistic_2
URL: https://metacpan.org/release/MooX-Const

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RR/RRWO/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This is syntactic sugar for using the Types::Const manpage with the Moo manpage. The
SYNOPSIS above is equivalent to:

  use Types::Const -types;

  has thing => (
    is     => 'ro',
    isa    => Const[ArrayRef[HashRef]],
    coerce => 1,
  );

It modifies the `has' function to support "const" attributes.  These
are read-only ("ro") attributes for references, where the underlying
data structure has been set as read-only.

This will return an error if there is no "isa", the "isa" is not a
the Type::Tiny manpage type, if it is not a reference, or if it is blessed
object.

Simple value types such as `Int' or `Str' are silently converted to
read-only attributes.

As of v0.2.0, it also supports write-once ("wo") attributes for
references:

  has setting => (
    is  => 'wo',
    isa => HashRef,
  );

This allows you to set the attribute *once*. The value is coerced
into a constant, and cannot be changed again.

=for Pod::Coverage VERSION

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE Changes
%perl_vendor_privlib/M*

%changelog
