%define module_name MooX-Enumeration
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Eval/TypeTiny.pm) perl(ExtUtils/MakeMaker.pm) perl(Moo.pm) perl(Moose.pm) perl(MooseX/Enumeration.pm) perl(MooseX/Enumeration/Meta/Attribute/Native/Trait/Enumeration.pm) perl(Sub/Util.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(Type/Tiny/Enum.pm) perl(Types/Standard.pm) perl(match/simple.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.010
Release: alt1
Summary: shortcuts for working with enum attributes in Moo
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/MooX-Enumeration

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBYINK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is a Moo implementation of the MooseX::Enumeration manpage. All the features
from the Moose version should work here.

Passing `traits => ["Enumeration"]' to `has' is not needed with
MooX::Enumeration. This module's magic is automatically applied to all
attributes with a the Type::Tiny::Enum manpage type constraint.

Simple example:

   package MyClass {
      use Moo;
      use MooX::Enumeration;
      
      has xyz => (is => "ro", enum => [qw/foo bar baz/], handles => 1);
   }

`MyClass->new(xyz => "quux")' will throw an error.

Objects of the class will have `$object->is_foo', `$object->is_bar',
and `$object->is_baz' methods.

For more details of method delegation, see the MooseX::Enumeration manpage.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes CREDITS LICENSE COPYRIGHT README
%perl_vendor_privlib/M*

%changelog
