%define module_name MooX-PDL-Role-Proxy
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/Yath/Util.pm) perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Hash/Wrap.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Lexical/Accessor.pm) perl(Module/Build/Tiny.pm) perl(Module/Load.pm) perl(Moo.pm) perl(Moo/Role.pm) perl(MooX/TaggedAttributes.pm) perl(PDL.pm) perl(PDL/Lite.pm) perl(PDL/Primitive.pm) perl(Role/Tiny.pm) perl(Role/Tiny/With.pm) perl(Scalar/Util.pm) perl(Test/Lib.pm) perl(Test/More.pm) perl(Test2/Tools/PDL.pm) perl(Test2/V0.pm) perl(Types/Standard.pm) perl(constant.pm) perl(namespace/clean.pm) perl(overload.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: treat a container of piddles as if it were a piddle
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DJ/DJERIUS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
MooX::PDL::Role::Proxy is a the Moo::Role manpage which turns its
consumer into a proxy object for some of its attributes, which are
assumed to be PDL objects (or other proxy objects). A subset of
PDL methods applied to the proxy object are applied to the selected
attributes. (See the PDL::QuckStart manpage for more information on PDL and
its objects (piddles)).

As an example, consider an object representing a set of detected
events (think physics, not computing), which contains metadata
describing the events as well as piddles representing event position,
energy, and arrival time.  The structure might look like this:

  {
      metadata => \%%metadata,
      time   => $time,         # piddle
      x      => $x,            # piddle
      y      => $y,            # piddle
      energy => $energy        # piddle
  }

To filter the events on energy would traditionally be performed
explicitly on each element in the structure, e.g.

  my $mask = which( $obj->{energy} > 20 );

  my $copy = {};
  $copy->{time}   = $obj->{time}->where( $mask );
  $copy->{x}      = $obj->{x}->where( $mask );
  $copy->{y}      = $obj->{y}->where( $mask );
  $copy->{energy} = $obj->{energy}->where( $mask );

Or, more succinctly,

  $new->{$_} = $obj->{$_}->where( $mask ) for qw( time x y energy );

With MooX::PDL::Role::Proxy this turns into

  my $copy = $obj->where( $mask );

Or, if the results should be stored in the same object,

  $obj->inplace->where( $mask );

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CONTRIBUTING.md LICENSE Changes README
%perl_vendor_privlib/M*

%changelog
