Epoch: 1
%define module_name MooX-Role-HasLogger
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/MakeMaker/CPANfile.pm) perl(File/Spec.pm) perl(Log/Any.pm) perl(Log/Log4perl.pm) perl(Moo.pm) perl(MooX/TypeTiny.pm) perl(Test/More.pm) perl(Test/Output.pm) perl(Type/Tiny.pm) perl(lib.pm) perl(namespace/clean.pm) perl(subs.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt2
Summary: Moo role that provides a logger attribute
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SV/SVW/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This the Moo::Role manpage based role provides a `logger' attribute to the consuming
class.  The attribute is read-only and its value is grabbed lazily. The type
library the MooX::Role::HasLogger::Types manpage exports the `Logger' type that defines
the interface of the attribute. The `build_logger()' builder method returns a
the Log::Any manpage logger object with the consuming class as its category.

This example

  package Bar;

  use Moo;
  use MooX::TypeTiny;
  use Types::Standard              qw( HasMethods );
  use MooX::Role::HasLogger::Types qw( Logger );
  use namespace::clean;

  with qw( MooX::Role::HasLogger );

  has '+logger' => ( isa => ( Logger ) & ( HasMethods [ qw( tracef debugf infof warnf errorf fatalf ) ] ) );

  sub build_logger {
    return Log::Any->get_logger( category => ref shift, default_adapter => 'Stderr' );
  }

  1;

shows

=over 2

=item *

how to override the `isa' option of the `logger' attribute using the `+'
notation.

=item *

how to extend the `Logger' type using a the Type::Tiny manpage intersection. Now a
logger has to be an object of a class that implements the `Logger' type
methods and additionally the `f' suffixed log methods.

=item *

how to override the `build_logger()' builder method. This time the builder
returns a the Log::Any manpage logger object with the consuming class as its category
and with a default adapter that refers to the the Log::Any::Adapter::Stderr manpage
adapter class.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/M*

%changelog
