# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Pod/Coverage/TrustPod.pm) perl(Test/CPAN/Changes.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(parent.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    MooX-Role-POE-Emitter
%define upstream_version 1.001002

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_5

Summary:    Pluggable POE event emitter role for cows
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        http://search.cpan.org/dist/%{upstream_name}
Source0:    http://www.cpan.org/modules/by-module/MooX/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(List/Objects/Types.pm)
BuildRequires: perl(List/Objects/WithUtils.pm)
BuildRequires: perl(Moo.pm)
BuildRequires: perl(MooX/late.pm)
BuildRequires: perl(MooX/Role/Pluggable.pm)
BuildRequires: perl(MooX/Types/MooseLike.pm)
BuildRequires: perl(POE.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildRequires: perl(Test/Exception.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Try/Tiny.pm)
BuildRequires: perl(Types/Standard.pm)
BuildRequires: perl(namespace/clean.pm)
BuildRequires: perl(strictures.pm)
BuildArch:  noarch
Source44: import.info

%description
This is a the Moo::Role manpage for a the POE manpage Observer Pattern
implementation; it is derived from the POE::Component::Syndicator manpage
by BINGOS, HINRIK, APOCAL et al, but with more cows ;-)

Consuming this role gives your class a the POE::Session manpage capable of
emitting events to loaded plugins and registered "listener" sessions. It
also brings in the MooX::Role::Pluggable manpage, making your emitter
pluggable (see the the MooX::Role::Pluggable manpage documentation for
plugin-related details).

You do not need to create your own the POE::Session manpage; calling the
/_start_emitter manpage will spawn one for you.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make

%check
%make test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README.mkdn
%{perl_vendor_privlib}/*


%changelog
