# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Object/Pluggable.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/CPAN/Changes.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Synopsis.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    MooX-Role-Pluggable
%define upstream_version 1.002002

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_6

Summary:    MooX::Role::Pluggable EAT values
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/MooX/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(Moo.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Try/Tiny.pm)
BuildRequires: perl(Type/Tiny.pm)
BuildRequires: perl(parent.pm)
BuildRequires: perl(strictures.pm)
BuildArch:  noarch
Source44: import.info

%description
A the Moo::Role manpage for turning instances of your class into pluggable
objects. Consumers of this role gain a plugin pipeline and methods to
manipulate it, as well as a flexible dispatch system (see the
/_pluggable_process manpage).

The logic and behavior is based almost entirely on the Object::Pluggable
manpage. Some methods are the same; implementation & interface differ some
(dispatch is slightly faster, also) and you will still want to read
thoroughly if coming from the Object::Pluggable manpage.

It may be worth noting that this is nothing at all like the Moose
counterpart the MooseX::Role::Pluggable manpage. If the names confuse ...
well, I lacked for better ideas. ;-)

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml 
%{perl_vendor_privlib}/*

%changelog
