# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Method/Modifiers.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON/MaybeXS.pm) perl(Moo.pm) perl(Test/Most.pm)
# END SourceDeps(oneline)
%define module_name MooX-TO_JSON
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: Generate a TO_JSON method from attributes.
Group: Development/Perl
License: perl
URL: https://github.com/jjn1056/MooX-TO_JSON

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JJ/JJNAPIORK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Make it easier to correctly encode your the Moo manpage object into JSON.  It does this
by inspecting your attributes and injection a `TO_JSON' method into your class.
You can tag how the attribute will serialize to JSON (forcing it into string or
number / boolean).  

    has name => (is=>'ro', json=>1);

Setting the `json' argument to 1 will serialize the attribute value to JSON use
the defaults (that is the field name is the same as the attribute name, value is
serialized even if `undef' and no value coercions (to number or boolean for example)
are forced).

    has age => (is=>'ro', json=>'age-years,num');

Here `age' will be mapped to 'age-years' and the value forced into number context so
that when the JSON encoder touches it the serialized value will be a number not a string.

    has alive => (is=>'ro', json=>',bool');

In this case the value is forced to boolean JSON context.

    has possibly_empty => (is=>'ro', json=>',omit_if_empty');

Lastly if the final tag in the 'json' string is 'omit_if_empty' we will omit including
the field in the JSON output IF the attribute is not present (please note `undef' is
considered 'present/existing'.)  In order to do this we need to set a `predicate' arg
for the attribute (or use one if you define it).  This will slighly pollute the object
namespace with the predicate method for each attribute you mark such.

Your class can also contain a method `modify_json' which
takes the serialized attributes and allows you to add to them or modify them.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.mkdn README LICENSE Changes
%perl_vendor_privlib/M*

%changelog
