%define module_name MooX-ValidateSubs
# BEGIN SourceDeps(oneline):
BuildRequires: perl(B.pm) perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(Module/Metadata.pm) perl(Moo.pm) perl(MooX/ReturnModifiers.pm) perl(Moose.pm) perl(Test/More.pm) perl(Type/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.012009
Release: alt1
Summary: Validating sub routines via Type::Tiny.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LN/LNATION/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
package Welcome::To::A::World::Of::Types;

    use Moo;
    use MooX::ValidateSubs;
    use Types::Standard qw/Str ArrayRef HashRef/;

    validate_subs (
        hello_world => {
            params => { 
                one   => [ Str, 1 ], # 1 means I'm optional
                two   => [ ArrayRef ],
                three => [ HashRef, 'before_add_me' ],
            },
            returns => {
                one   => [ Str, 1 ], # 1 means I'm optional
                two   => [ ArrayRef ],
                three => [ HashRef ],
                four  => [ Str, 'add_on' ],
            },
        },
        goodbye_world => { params => [ [Str], [ArrayRef], [HashRef] ] },
    );

    sub before_add_me {
        return {
            okay => 'fine',
        };
    }

    sub add_on {
        return 'sad face';
    }

    sub hello_world { 
        my ($self, %%args) = @_;
        
        # $args{one}    # optional string 
        # $args{two}    # valid arrayref 
        # $args{three}  # valid hashref

        if ( ... # some condition ... ) {
            $args{four} = 'may or may not get set here';
        }

        return %%args;
    }
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md ignore.txt README
%perl_vendor_privlib/M*

%changelog
