%define module_name MooX-XSConstructor
# BEGIN SourceDeps(oneline):
BuildRequires: perl(B.pm) perl(Class/XSConstructor.pm) perl(ExtUtils/MakeMaker.pm) perl(Hook/AfterRuntime.pm) perl(Moo.pm) perl(Scalar/Util.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(Test/Warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: glue between Moo and Class::XSConstructor
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/MooX-XSConstructor

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBYINK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
MooX::XSConstructor will look at your class attributes, and see if it
could be built using the simple constructor that the Class::XSConstructor manpage is
able to provide.

If your class is too complicated, it is a no-op.

If your class is simple enough, you will hopefully get a faster constructor.

Things that are deemed too complicated if they appear in *any* attributes
(even an inherited one):

=over

=item *

Eager builders and defaults. (Lazy builders and defaults are fine.)

=item *

Type constraints. (Except Type::Tiny, which is fine.)

=item *

Type coercions.

=item *

Triggers.

=item *

Use of `init_arg'.

=item *

Use of `weak_ref'.

=back

Also if your class has a `BUILDARGS' or `FOREIGNBUIDARGS' method, it will
be too complicated. (The default `BUILDARGS' inherited from the Moo::Object manpage
is fine.)

So what Moo features are okay?

Required versus optional attributes, the Type::Tiny manpage type constraints (but not
coercions), reader/writer/predicate/clearer, lazy defaults/builders, and
delegation (`handles').

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE CREDITS Changes COPYRIGHT
%perl_vendor_privlib/M*

%changelog
