%define module_name Moonshine-Template
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Hash/Merge.pm) perl(Hash/Util.pm) perl(Module/Metadata.pm) perl(Moonshine/Element.pm) perl(Ref/Util.pm) perl(Test/More.pm) perl(UNIVERSAL/Object.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: Template some more html.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LN/LNATION/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
package MyApp::Template::World

    our @ISA; BEGIN { @ISA = 'Moonshine::Template' }

    ***** now you have a choice - however a base element is required *****
    sub base_element {
       return {
          tag => 'div'
          class => 'test'
       }
    }

    sub build_html {
        my ($self, $base) = @_;

        my $ul = $base->add_child({ tag => 'ul' });
        for (qw/one two three/) {
            $ul->add_child({ tag => 'li', class => $_, data => [ $_ ] });
        }
        return $base;
    }
 
    ***** or *****
    MyApp::Template::World->new({ base_element => { tag => div, class => test }});
    
    sub build_html {
        my ($self, $base) = @_;
        ...
    }                          


    ***** or *****
    sub build_html {
       my $self = shift; 

       my $base = $self->add_base_element({ tag => 'div' });
       ...
       return $base;
    }
       
    package Test::HTML;

    our @ISA;
    BEGIN { @ISA = 'Moonshine::Template' }

    sub config {
        return {
            base_element => {
                tag => 'html',
            },
            header => {
                build => {
                    tag => 'head',
                },
                target => 'base_element',
            },
            page_title => {
                build => {
                    tag  => 'title',
                    data => 'Page Title',
                },
                target => 'header',
            },
            body => {
                build => {
                    tag => 'body',
                },
                action => 'add_after_element',
                target => 'header',
            },
        };
    }

    sub build_html {
        return $_[1];
    }

    package Test::HTML::Content;

    our @ISA;
    BEGIN { @ISA = 'Moonshine::Template' }

    sub config {
        return {
            base_element => {
                tag => 'div',
            },
            title => {
                tag  => 'h1',
                data => 'Hello World',
            },
     ...
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/M*

%changelog
