%define module_name MooseX-App
Epoch: 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config/Any.pm) perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/HomeDir.pm) perl(File/Spec.pm) perl(IO/Interactive.pm) perl(List/Util.pm) perl(Module/Pluggable.pm) perl(Moose.pm) perl(Pod/Elemental.pm) perl(Pod/Perldoc.pm) perl(Term/ANSIColor.pm) perl(Term/ReadKey.pm) perl(Test/Exception.pm) perl(Test/Most.pm) perl(Test/NoWarnings.pm) perl(Text/WagnerFischer.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.43
Release: alt1
Summary: Write user-friendly command line apps with even less suffering
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MA/MAROS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
MooseX-App is a highly customizeable helper to write user-friendly 
command line applications without having to worry about most of the annoying 
things usually involved. Just take any existing the Moose manpage class, add a single 
line (`use MooseX-App qw(PluginA PluginB ...);') and create one class
for each command in an underlying namespace.

MooseX-App will then take care of

=over

=item * Finding, loading and initializing the command classes

=item * Creating automated help and documentation from pod and attributes

=item * Reading, encoding and validating the command line options and positional parameters entered by the user

=item * Providing helpful error messages if user input cannot be validated

=back

Commandline options are defined using the 'option' keyword which accepts
the same attributes as Moose' 'has' keyword.

  option 'some_option' => (
      is            => 'rw',
      isa           => 'Str',
  );

This is equivalent to

  has 'some_option' => (
      is            => 'rw',
      isa           => 'Str',
      traits        => ['AppOption'],
      cmd_type      => 'option',
  );

Positional parameters are defined with the 'parameter' keyword

  parameter 'some_option' => (
      is            => 'rw',
      isa           => 'Str',
  );

This is equivalent to

  has 'some_option' => (
      is            => 'rw',
      isa           => 'Str',
      traits        => ['AppOption'],
      cmd_type      => 'parameter',
  );

Read the Tutorial for getting started with a simple 
MooseX::App command line application.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE TODO Changes
%perl_vendor_privlib/M*

%changelog
