%define module_name MooseX-App-Plugin-ZshCompletion
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(Moose/Util/TypeConstraints.pm) perl(MooseX/App.pm) perl(MooseX/App/Command.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(lib.pm) perl(namespace/autoclean.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: zsh completion for your MooseX::App applications
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TI/TINITA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This plugin generates a zsh completion definition for your application.

Completion works for subcommands, parameters and options. If an option or
parameter is declared as an `enum' with the Moose::Meta::TypeConstraint manpage you
will get a completion for the enum values.

Option completions will show its descriptions also.

The default completion type for parameters is `_files'

In the examples directory you find `myapp'.

    %% myapp <TAB>
    bash_completion  fetch_mail    help          lala          zsh_completion

    %% myapp fetch_mail server.example -<TAB>
    --dir                     -- Output 'dir'
    --max                     -- Maximum number of emails to fetch
    --servertype              -- Mailserver type: IMAP or POP3
    --usage       --help  -h  -- Prints this usage information.
    --user                    -- User
    --verbose                 -- be verbose

    %% myapp fetch_mail server.example --servertype <TAB>
    IMAP  POP3
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README README.md Changes LICENSE examples
%perl_vendor_privlib/M*

%changelog
