# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Moose/Util/TypeConstraints.pm) perl(MooseX/AttributeHelpers.pm) perl(Scalar/Util.pm) perl(Sub/Exporter.pm) perl(Test/More.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name MooseX-Attributes-Curried
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1.1
Summary: curry your "has"es
Group: Development/Perl
License: perl
URL: http://github.com/sartak/moosex-attributes-curried/tree

Source0: http://cpan.org.ua/authors/id/S/SA/SARTAK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module lets you define curried versions of the has entry in the Moose manpage. If many of your
attributes share the same options, especially across multiple classes, then you
can refactor those options away into a curried `has'.

Typical usage of this extension is to create a standalone "`has' library"
module. If you only need a curried `has' for one class, then you might as
well just define a `sub has_datetime { has(...) }' in that class.

When you use your "`has' library", you can customize each curried `has'
further by specifying additional options on your import line, like so:

    use MyAttrs (
        has_datetime => {
            is => 'ro',
        },
        has_datetime => {
            -as      => 'needs_datetime',
            required => 1,
        },
    );

Your "defaults" for the attribute can also be a code reference. This code
reference will receive both the additional specializations performed when
the curried attribute was imported, as well as any additional specializations
used in the individual attribute. This is immensely powerful, see
t/007-smart-has.t for a taste.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/M*

%changelog
