%define module_version 0.004
%define module_name MooseX-CustomInitArgs
# BEGIN SourceDeps(oneline):
BuildRequires: perl(B.pm) perl(Data/OptList.pm) perl(ExtUtils/MakeMaker.pm) perl(Moose.pm) perl(Moose/Exporter.pm) perl(Moose/Role.pm) perl(Moose/Util/TypeConstraints.pm) perl(Test/Fatal.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.004
Release: alt1.1
Summary: define multiple init args with custom processing
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/MooseX-CustomInitArgs

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
`MooseX::CustomInitArgs' allows Moose attributes to be initialized from
alternative initialization arguments. If you find yourself wishing that
Moose's built-in `init_arg' option took an arrayref, then this is what
you want.

the MooseX::MultiInitArg manpage also does this, but `MooseX::CustomInitArgs' has
an additional feature: it can optionally pre-process each initialization
argument. This happens prior to type coercian and constraint checks.

(Also at the time of writing, `MooseX::MultiInitArg' suffers from a bug
where it breaks when a class is immutablized.)

The constructor cannot be called with multiple initialization arguments
for the same attribute. Given the class in the example, this would throw
an error:

   my $circle = Circle->new(radius => 1, diameter => 100);

The following would also throw an error, even though it's slightly more
sensible:

   my $circle = Circle->new(radius => 1, diameter => 2);

The `init_args' attribute option is conceptually a hash mapping
initialization argument names to methods which pre-process them. The methods
can be given as coderefs, or the names of class methods as strings (or scalar
refs).

You can provide this hash mapping as an actual hashref, or (as in the
the SYNOPSIS entry elsewhere in this document) as an arrayref suitable for input to the Data::OptList manpage. In either
case it will be coerced to `MooseX::CustomInitArgs''s internal representation
which is a `Data::OptList'-style arrayref of arrayrefs.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE COPYRIGHT
%perl_vendor_privlib/M*

%changelog
