%define module_name MooseX-DIC
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter/Declare.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Find.pm) perl(File/Slurper.pm) perl(File/Spec.pm) perl(Log/Log4perl.pm) perl(Module/Load.pm) perl(Moose.pm) perl(MooseX/Role/Parameterized.pm) perl(Test/Spec.pm) perl(Throwable.pm) perl(Try/Tiny.pm) perl(YAML/XS.pm) perl(aliased.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.5.0
Release: alt1
Summary: A dependency injector container for Moose
Group: Development/Perl
License: apache
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LP/LPRIETO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Full documentation on the MooseX::DIC Webpage.

MooseX::DIC is a dependency injection container tailored to the Moose manpage, living in a full OOP environment and greatly
inspired by Java DIC frameworks like Spring
or CDI.

The goal of this library is to provide an easy to use DI container with automatic wiring of dependencies via constructor 
by class type (ideally by Role/Interface).

The configuration is performed either by the use of Marker roles and
a specific trait on attributes that have to be injected, or by use of a very terse and composable yaml config file, using sensible
defaults to cover 90%% of the use cases to minimize boilerplate.

One of the principal tenets of the library is that while code may be poluted by the use of DIC roles and traits, it
should work without a running container. The classes are fully functional without the dependency injection, the library
is just a convenient way to wire dependencies (this is mainly accomplished by forbidding non constructor injection).

This library is designed to be used on long-running processes where startup time is not a concern (within reason, of
course). The container will scan all configured paths to look for services to inject and classes that need injection.

There is a great amount of flexibility to account for testing environments, non-moose libraries, alternative
implementations of services, etc, although none of it is needed for a simple usage.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md CHANGES
%perl_vendor_privlib/M*

%changelog
