%define module_version 0.004
%define module_name MooseX-Does-Delegated
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(Moose/Util.pm) perl(Test/More.pm) perl(if.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.004
Release: alt1.1
Summary: allow your class's DOES method to respond the affirmative to delegated roles
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/MooseX-Does-Delegated

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
According to the UNIVERSAL manpage the point of `DOES' is that it allows you
to check whether an object does a role without caring about *how*
it does the role.

However, the default Moose implementation of `DOES' (which you can
of course override!) only checks whether the object does the role via
inheritance or the application of a role to a class.

This module overrides your object's `DOES' method, allowing it to
respond the affirmative to delegated roles. This module is a standard
Moose role, so it can be used like this:

   with qw( MooseX::Does::Delegated );

Alternatively, if you wish to apply this role ubiqitously (i.e. to all
Moose objects in your application) - as is your prerogative - you can use:

   use MooseX::Does::Delegated -everywhere;

This will apply the role to the Moose::Object base class.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE COPYRIGHT Changes README
%perl_vendor_privlib/M*

%changelog
