%define module_name MooseX-Extended
# BEGIN SourceDeps(oneline):
BuildRequires: perl(B/Hooks/AtRuntime.pm) perl(Capture/Tiny.pm) perl(Carp.pm) perl(Data/Printer.pm) perl(DateTime.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Function/Parameters.pm) perl(Future/AsyncAwait.pm) perl(IO/Async/Loop.pm) perl(Import/Into.pm) perl(List/Util.pm) perl(Module/Load.pm) perl(Moose.pm) perl(Moose/Exception.pm) perl(Moose/Exception/Role/Class.pm) perl(Moose/Exporter.pm) perl(Moose/Meta/Role.pm) perl(Moose/Role.pm) perl(Moose/Util.pm) perl(MooseX/Role/WarnOnConflict.pm) perl(MooseX/StrictConstructor.pm) perl(Ref/Util.pm) perl(Scalar/Util.pm) perl(Storable.pm) perl(Syntax/Keyword/MultiSub.pm) perl(Syntax/Keyword/Try.pm) perl(Test/Builder.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(Type/Library.pm) perl(Type/Params.pm) perl(Type/Tiny.pm) perl(Type/Utils.pm)
BuildRequires: perl(Types/Common/Numeric.pm) perl(Types/Common/String.pm) perl(Types/Standard.pm) perl(base.pm) perl(constant.pm) perl(feature.pm) perl(lib.pm) perl(mro.pm) perl(namespace/autoclean.pm) perl(parent.pm) perl(strict.pm) perl(true.pm) perl(version.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.35
Release: alt1
Summary: Extend Moose with safe defaults and useful features
Group: Development/Perl
License: artistic_2
URL: https://github.com/Ovid/moosex-extended

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/O/OV/OVID/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is ALPHA code.

This class attempts to create a safer version of Moose that defaults to
read-only attributes and is easier to read and write.

It tries to bring some of the lessons learned from the Corinna project,
while acknowledging that you can't always get what you want (such as
true encapsulation and true methods).

This:

    package My::Class {
        use MooseX::Extended;

        ... your code here
    }

Is sort of the equivalent to:

    package My::Class {
        use v5.20.0;
        use Moose;
        use MooseX::StrictConstructor;
        use feature qw( signatures postderef postderef_qq);
        no warnings qw( experimental::signatures experimental::postderef );
        use namespace::autoclean;
        use Carp;
        use mro 'c3';

        ... your code here

        __PACKAGE__->meta->make_immutable;
    }
    1;

It also exports two functions which are similar to Moose `has': `param' and
`field'.

A `param' is a required parameter (defaults may be used). A `field' is not
allowed to be passed to the constructor.

Note that the `has' function is still available, even if it's not needed.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes CONTRIBUTING.md LICENSE
%perl_vendor_privlib/M*

%changelog
