%define module_name MooseX-FileAttribute
# BEGIN SourceDeps(oneline):
BuildRequires: perl(File/Spec.pm) perl(Module/Build.pm) perl(Module/Build/Tiny.pm) perl(Module/Metadata.pm) perl(Moose.pm) perl(Moose/Exporter.pm) perl(MooseX/Types.pm) perl(MooseX/Types/Moose.pm) perl(MooseX/Types/Path/Class.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: sugar for classes that have file or directory attributes
Group: Development/Perl
License: perl
URL: https://github.com/moose/MooseX-FileAttribute

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/ET/ETHER/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
I write a lot of classes that take files or directories on the
command-line.  This results in a lot of boilerplate, usually:

   package Class;
   use Moose;
   use MooseX::Types::Path::Class qw(File);

   has 'foo' => (
       is       => 'ro',
       isa      => File,
       coerce   => 1,
       required => 1,
   );

This module lets you save yourself some typing in this case:

   has_file 'foo' => ( required => 1 );

These are exactly equivalent.  `has_directory' does the same thing
that `has_file' does, but with a `Dir' constraint.

This module also defines two additional type constraints to ensure
that the specified file or directory exists and is a file or
directory.  You can use these constraints instead of the defaults by
passing `must_exist => 1' to the `has_*' function.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/M*

%changelog
