%define module_name MooseX-Final
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Class/Tiny.pm) perl(Exporter/Tiny.pm) perl(ExtUtils/MakeMaker.pm) perl(Moo.pm) perl(Moose.pm) perl(Mouse.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(Test/Requires.pm) perl(UNIVERSAL/Object.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: mark a class as "final" (cannot be inherited from)
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/MooseX-Final

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBYINK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This package allows you to mark a class as being "final". A final class
is at the top of the inheritance hierarchy. It cannot be inherited from.
You almost certainly don't want this. Why prevent people from inheriting
from your class? There's no good reason.

Nevertheless, if you have a bad reason, you can use this module to do it.
Despite the name, this module should work fine with the Moose manpage, the Moo manpage,
the Mouse manpage, the Class::Tiny manpage, and any other class builder that properly
supports the concept of `BUILD' methods.

This is not 100%% foolproof. Subclasses can probably work around it
without a massive amount of difficulty. But if you're trying to subclass
a class that has indicated it should be final, perhaps you should think
of another way of achieving your aims. (Hint: delegation.)

Note that the exception is thrown when you try to *instantiate* the
subclass, not when you try to define the subclass.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE CREDITS Changes README COPYRIGHT
%perl_vendor_privlib/M*

%changelog
