%define module_version 0.003
%define module_name MooseX-FunkyAttributes
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter/Shiny.pm) perl(ExtUtils/MakeMaker.pm) perl(Hash/FieldHash.pm) perl(Math/Trig.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(MooseX/CustomInitArgs.pm) perl(Scalar/Util.pm) perl(Test/Fatal.pm) perl(Test/Moose.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(aliased.pm) perl(namespace/autoclean.pm) perl(thanks.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1.1
Summary: add code smell to your Moose attributes
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/MooseX-FunkyAttributes

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The MooseX::FunkyAttributes module itself just provides some convenience
functions for the attribute traits that are distributed with it. 

The grand uniting idea behind the traits is that although Moose generally
uses blessed hashrefs for object internals, storing each attribute as an
entry in the hash, sometimes you may want to change that behaviour for
individual attributes. For example, you could use the inside-out technique
for one attribute to suppress it from appearing in the Data::Dumper manpage dumps.

The traits bundled with MooseX::FunkyAttributes are as follows. Please
see the documentation for each individual trait for further details.

=over

=item * the MooseX::FunkyAttributes::Role::Attribute manpage

Allows you to override the get, set, clear and predicate operations for an
attribute. These are just the raw operations you're overriding; you do not
need to implement type constraint checking, coercians, checking required
attributes, defaults, builders, etc.

With this trait you can create attributes which are calculated on the fly
(as in the SYNOPSIS) or stored somewhere outside the object's blessed
hashref.

=item * the MooseX::FunkyAttributes::Role::Attribute::InsideOut manpage

This trait stores the attribute using the inside-out technique. If you want
your whole object to be inside-out, then use the MooseX::InsideOut manpage.

=item * the MooseX::FunkyAttributes::Role::Attribute::Delegated manpage

This trait delegates the storage of one attribute to another attribute.
For example:

   package Head;
   use Moose;
   has mouth => (
      is           => 'ro',
      isa          => 'Mouth',
   );
   
   package Person;
   use Moose;
   use MooseX::FunkyAttributes;
   has head => (
      is           => 'ro',
      isa          => 'Head',
   );
   has mouth => (
      is           => 'ro',
      isa          => 'Mouth::Human',
      traits       => [ DelegatedAttribute ],
      delegated_to => 'head',
   );

It is not dissimilar to the Moose's idea of "handles" (in the example above,
we could have not defined a `mouth' attribute as part of the `Person' class,
and just specified that `head' handles `mouth') however because `mouth'
is now a proper attribute in the Person class (and will show up via Moose's
introspection API), it can have its own type constraints, coercion, trigger,
predicate, etc.

=back

The MooseX::FunkyAttributes module itself exports some constants (e.g.
`FunkyAttribute' in the SYNOPSIS) which can be used as abbreviations for
the full trait package names. These constants are:

=over

=item `FunkyAttribute'

=item `InsideOutAttribute'

=item `DelegatedAttribute'

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE COPYRIGHT README examples
%perl_vendor_privlib/M*

%changelog
