%define module_version 0.24
%define module_name MooseX-Getopt-Usage
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Capture/Tiny.pm) perl(Config.pm) perl(File/Basename.pm) perl(File/Slurp.pm) perl(FindBin.pm) perl(Module/Build.pm) perl(Module/Build/Compat.pm) perl(Module/Loaded.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(Moose/Util/TypeConstraints.pm) perl(MooseX/Getopt.pm) perl(MooseX/Getopt/Basic.pm) perl(Pod/Find.pm) perl(Pod/Select.pm) perl(Pod/Text.pm) perl(Pod/Usage.pm) perl(Term/ANSIColor.pm) perl(Term/ReadKey.pm) perl(Test/Class.pm) perl(Test/Differences.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Text/Wrap.pm) perl(Try/Tiny.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.24
Release: alt1.1
Summary: Extend MooseX::Getopt with usage message and man page generated from attribute meta and POD.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/P/PI/PITCHLESS/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Perl Moose Role that extends the MooseX::Getopt manpage to provide usage printing and
man page generation that inspects your classes meta information to build a
(coloured) usage message including that meta information.

If STDOUT is a tty usage message is colourised. Setting the env var
ANSI_COLORS_DISABLED will disable colour even on a tty.

The message is formatted to the width of the terminal when STDOUT is a tty, to
a width of 72 characters otherwise.

Errors in command line option parsing will be displayed along with the usage,
causing the program to exit with a non-zero status code when new_with_options
is used.

The usage message can be extended and controlled by including sections selected
from the modules POD, with the default to automatically generate SYNOPSIS and
OPTIONS sections.

By also using the the MooseX::Getopt::Usage::Role::Man manpage role a --man option is
added to your class that will display the man page generated from your modules
POD documentation. This POD will include the generated SYNOPSIS and OPTIONS
sections if they are selected.

This is all much inspired (and partly implemented) by the excellent
the Pod::Usage manpage module, but with added Moose meta goodness.



%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README examples
%perl_vendor_privlib/M*

%changelog
