%define module_name MooseX-LocalAttribute
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Accessor.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(FindBin.pm) perl(Mo.pm) perl(Mojo/Base.pm) perl(Moo.pm) perl(Moose.pm) perl(Mouse.pm) perl(Object/Pad.pm) perl(Scope/Guard.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Requires.pm) perl(Util/H2O.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: local-ize attributes on Moose-ish objects
Group: Development/Perl
License: perl
URL: https://github.com/simbabque/MooseX-LocalAttribute

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SI/SIMBABQUE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides a mechanism to temporarily replace the value of an
object attribute with a different variable. In typical object oriented Perl
code, an object contains a blessed hash reference, so it's possible to reach
into the internals to localise data.

    my $local_bar;
    local $foo->{bar} = \$local_bar;

This has a few problems though. It is generally a better idea to use accessors
rather than to rumage around in the internals of an object. This is especially
true if one does not know whether the object is in fact a hash reference under
the hood.

When a variable is localised with `local', a backup of that variable is made.
Perl then places a directive on the stack that restores the variable when it
is goes out of scope. This module does the same thing for attributes of
objects.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes
%perl_vendor_privlib/M*

%changelog
