%define module_version 0.004
%define module_name MooseX-ModifyTaggedMethods
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(List/MoreUtils.pm) perl(Moose.pm) perl(Moose/Exporter.pm) perl(Moose/Role.pm) perl(MooseX/RoleQR.pm) perl(Sub/Talisman.pm) perl(Test/More.pm) perl(attributes.pm) perl(match/simple.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.004
Release: alt1.1
Summary: use sub attributes to specify which methods want modifiers
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/MooseX-ModifyTaggedMethods

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Normally Moose classes can specify method modifiers by name, an arrayref
of names, or via a regular expression. Moose roles are more limited, not
allowing regular expressions.

MooseX::RoleQR extends the functionality for roles, allowing them to use
regular expressions to specify method modifiers. MooseX::ModifyTaggedMethods
goes even further, allowing classes and roles to use attributes (in the
the perlsub manpage sense of the word) to indicate which methods should be wrapped.

=over

=item `methods_tagged(@tags)'

This module exports a single function `methods_tagged' which can be used
in conjunction with `before', `after' and `around' to select methods
for modifying. What exactly it returns is best you don't know, but it
suffices to say that Moose and MooseX::RoleQR (but not plain Moose::Role)
know what to do with it.

=back

Note that Perl does not allow you to use any old attribute without first
declaring it:

 $ perl -MTest::More=no_plan -E'sub X :Y { }; ok(1)'
 Invalid CODE attribute: Y at -e line 1.
 BEGIN failed--compilation aborted at -e line 1.
 # Looks like your test exited with 255 before it could output anything.

the Sub::Talisman manpage provides an easy way of declaring attributes:

 $ perl -MSub::Talisman=Y -MTest::More=no_plan -E'sub X :Y { }; ok(1)'
 ok 1
 1..1

Sub::Talisman is used in the documentation and test cases for
MooseX::ModifyTaggedMethods, but any other technique that supports
`attributes::get($coderef)' will do.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes COPYRIGHT README
%perl_vendor_privlib/M*

%changelog
