# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Spec.pm) perl(File/Spec/Functions.pm) perl(Import/Into.pm) perl(Mojo/Base.pm) perl(Mojolicious/Plugin/ExposeControllerMethod.pm) perl(Moose.pm) perl(Moose/Exporter.pm) perl(Moose/Role.pm) perl(MooseX/NonMoose.pm) perl(MooseX/Types/Moose.pm) perl(Pod/Coverage/TrustPod.pm) perl(Pod/Wordlist.pm) perl(Test/CPAN/Changes.pm) perl(Test/EOL.pm) perl(Test/Mojo.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Spelling.pm) perl(Test/Synopsis.pm) perl(Test/Version.pm) perl(lib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_version 1.000001
%define module_name MooseX-MojoControllerExposingAttributes
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.000001
Release: alt1
Summary: Expose controller attributes to Mojolicious
Group: Development/Perl
License: perl
URL: http://metacpan.org/release/MooseX-MojoControllerExposingAttributes/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MA/MAXMIND/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module is for advanced use.  `$c'/`$self' are already made available in
templates and are likely sufficient for the majority of use cases.  This module
was created in order to expose the Moose manpage attributes in a way where you don't
have to stash them every single time you want to use them.

This class allows you to expose *selected* Moose attributes from your
Mojolicious controller to your templates by marking them with the `ExposeMojo'
trait.

Using this class in a Perl class does several things:

=over

=item It makes the class a subclass of Mojolicious::Controller

=item It sets up the class with Moose and Moose::NonMoose

=item It applies the extra role and metaclass traits to the class so this works with the Mojolicious::Plugin::ExposeControllerMethod manpage

=item It sets up the `ExposeMojo' trait

=back

So rather than declaring your controller class a Moose Mojolicious Controller in
the usual way:

   package MyApp::Controller::Example;
   use Mojo::Base 'Mojolicious::Controller';
   use Moose::NonMoose;
   use Moose;

You should simply say:

   package MyApp::Controller::Example;
   use MooseX::MojoControllerExposingAttributes;

Once you've done that then you can define attributes in the class (or in roles
the class consumes) that are exposed to Mojolicious.

  has some_attribute => (
      is     => 'ro',
      traits => ['ExposeMojo'],
  );

  has some_attribute_with_a_really_long_name => (
     is                => 'ro',
     traits            => ['ExposeMojo'],
     expose_to_mojo_as => 'shorter_name',
  );

In order to get the `ctrl' helper you should make sure you've loaded the
the Mojolicious::Plugin::ExposeControllerMethod manpage plugin somewhere in your
Mojolicious application, typically within the `startup' method itself:

    sub startup {
        my $self = shift;

        $self->plugin('ExposeControllerMethod');

        ...
    }

Then you'll be able to access your attributes from within templates that
are rendered from that controller:

   some attribute: <%%= ctrl->some...
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes
%perl_vendor_privlib/M*

%changelog
