%define module_version 0.12
%define module_name MooseX-NotRequired
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Moose/Meta/Class.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.12
Release: alt1.1
Summary: Make Moose sub classes with non required attributes.
Group: Development/Perl
License: perl
URL: https://github.com/colinnewell/MooseX-NotRequired

Source0: http://cpan.org.ua/authors/id/N/NE/NEWELLC/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module allows you to create anonymous sub classes of Moose classes with all the
required flags on the attributes turned off.

    package SalesOrder;
    
    use Moose;

    has order_number    => (is => 'ro', isa => 'Str', required => 1);
    has reference       => (is => 'ro', isa => 'Str' );
    has date_ordered    => (is => 'ro', isa => 'DateTime', required => 1);
    has total_value     => (is => 'ro', isa => 'Int', required => 1);
    has customer        => (is => 'ro', isa => 'Str', required => 1);
    has notes           => (is => 'ro', isa => 'Str');

    1;

    ...

    use MooseX::NotRequired;

    my $new_class = MooseX::NotRequired::make_optional_subclass('SalesOrder');
    my $obj = $new_class->new(); # no blow up
    my $default = $new_class->new({ semi_required => undef }); # fine too
    ...
    my $second = ObjectA->new(); # blow up because required fields not present
    my $third = ObjectA->new({ order_number => 'a', semi_required => undef }); 
    # blow up because semi_required must be a string.

This module exists because while you want to make use of Moose's awesome type constraints
they're sometimes a little inconvenient.  Rather than throw out all your restrictions
because you need your class to be a little more permissive in a few scenarios, create
a subclass that has some of those restrictions weakened.  You can of course do this manually.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/M*

%changelog
