%define module_name MooseX-RelClassTypes
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Clone.pm) perl(ExtUtils/MakeMaker.pm) perl(Module/Runtime.pm) perl(Moose.pm) perl(MooseX/Role/Parameterized.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: specify a class name in an attribute C<isa> relative to the current class
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOMGRACEY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
To group accessors it can be convenient to create a nested structure of Moose objects. For example, instead of having

    package Car;
    use Moose;

    has max_speed => (is => 'rw', isa => 'Int');
    has max_acceleration => (is => 'rw', isa => 'Int');
    has turning_circle => (is => 'rw', isa => 'Int');

    has height => (is => 'ro', isa => 'Int');
    has weight => (is => 'ro', isa => 'Int');
    has length => (is => 'ro', isa => 'Int');

    has color => (is => 'ro', isa => 'Str');
    has style => (is => 'ro', isa => 'Str');
    has seat_fabric => (is => ro', isa => 'Str');

    # ... other methods

you could group the attributes in some convenient way:

    package Car
    use Moose;

    has performance => (
        is => 'rw', 
        isa => 'Car::Performance'
    );

    has static_properties => (
        is => 'rw',
        isa => 'Car::Properties'
    );

    has appearance => (
        is => 'rw',
        isa => 'Car::Appearance'
    );

    # ... other methods

And Car::Performance would look like

    package Car::Performance
    use Moose;

    has max_speed => (
        is => 'rw',
        isa => 'Int'
    );

    has max_acceleration => (
        is => 'rw',
        isa => 'Int'
    );

    has turning_circle => (
        is => 'rw',
        isa => 'Int'
    );

with `Car::Properties' and `Car::Appearance' organised similarly. Then if you have an application which is only interested in performance (say) then your app can manipulate `Car::Performance' without having to load the whole car.

What if we have a truck?

    package Truck;

    use Moose;

    has performace => (
        is => 'rw',
        isa => 'Truck::Performance'
    );

    has static_properties => (
        is => 'rw',
        isa => 'Truck::Properties'
    );

    has appearance => (
        is => 'rw',
        isa => 'Truck::Appearance'
    );

This looks a lot like the `Car' package, but with `Car' replaced by `Truck' throughout. Now of course inheritance is the way to go in this situation:

    package Vehicle;
...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/M*

%changelog
