# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    MooseX-Role-BuildInstanceOf
%define upstream_version 0.08

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_10

Summary:    Less Boilerplate when you need lots of Instances
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/MooseX/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Class/MOP.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(List/MoreUtils.pm)
BuildRequires: perl(List/Util.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Moose/Role.pm)
BuildRequires: perl(Moose/Util/TypeConstraints.pm)
BuildRequires: perl(MooseX/Iterator.pm)
BuildRequires: perl(MooseX/Role/Parameterized.pm)
BuildRequires: perl(MooseX/Types/Path/Class.pm)
BuildRequires: perl(Perl6/Junction.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
There can often be a tension between coding for flexibility and for future
growth and writing code that is terse, to the point, and solves the
smallest possible business problem that is brought to you. Writing the
minimum code to solve a particular problem has merit, yet can eventually
leave you with an application that has many hacky modifications and is hard
to test in an isolated manner. Minimum code should not imply minimum
forward planning or poorly tested code.

For me, doing the right thing means I need to both limit myself to the
smallest possible solution for a given business case, yet make sure I am
not writing CODE that is impossible to grow over time in a clean manner.
Generally I attempt to do this by clearly separating the problem domains
under a business case into distinct classes. I then tie all the functional
bits together in the loosest manner possible. the Moose manpage makes this
easy, with its powerful attribute features, type coercions and Roles to
augment classical inheritance.

Loose coupling and deep configurability work well with inversion of control
systems, like the Bread::Board manpage or the IOC built into the the
Catalyst manpage MVC framework. It helps me to defer decisions to the
proper authority and also makes it easier to test my logic, since pieces
are easier to test independently.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml README
%perl_vendor_privlib/*

%changelog
