Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(YAML.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-MooseX-Role-Cmd
Version:        0.10
Release:        alt3_35
Summary:        Wrap system command binaries the Moose way
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/MooseX-Role-Cmd
Source0:        https://cpan.metacpan.org/authors/id/E/ED/EDENC/MooseX-Role-Cmd-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  rpm-build-perl
BuildRequires:  perl(inc/Module/Install.pm)
# Run-time
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(IPC/Cmd.pm)
BuildRequires:  perl(Moose/Role.pm)
BuildRequires:  perl(Moose/Util/TypeConstraints.pm)
# Tests
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Moose.pm)
BuildRequires:  perl(Test/Exception.pm)
BuildRequires:  perl(Test/More.pm)
Source44: import.info

%description
MooseX::Role::Cmd is a Moose role intended to ease the task of building
command-line wrapper modules. It automatically maps Moose objects into
command strings which are passed to IPC::Cmd.

%prep
%setup -q -n MooseX-Role-Cmd-%{version}

# Unbundle modules
rm -rf inc
sed -i -e '/^inc$/d' MANIFEST

# Filter requires
cat << \EOF > %{name}-req
#!/bin/sh
%{__perl_requires} $* |\
sed -e '/perl(MooseX::Role::Cmd::Meta::Attribute::Trait)/d'
EOF

%define __perl_requires %{_builddir}/MooseX-Role-Cmd-%{version}/%{name}-req
chmod +x %{__perl_requires}


%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT

find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
find $RPM_BUILD_ROOT -depth -type d -exec rmdir {} 2>/dev/null \;

# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc Changes
%{perl_vendor_privlib}/*

%changelog
