# BEGIN SourceDeps(oneline):
BuildRequires: perl(Capture/Tiny.pm) perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Moose.pm) perl(Moose/Exporter.pm) perl(Moose/Meta/Role.pm) perl(Moose/Meta/Role/Application/ToClass.pm) perl(Moose/Role.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(lib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name MooseX-Role-WarnOnConflict
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Warn if classes override role methods without excluding them
Group: Development/Perl
License: artistic_2
URL: https://github.com/Ovid/moosex-role-warn-on-conflict

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/O/OV/OVID/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
When using the Moose::Role manpage, a class which provides a method a role provides
will silently override that method.  This can cause strange, hard-to-debug
errors when the role's methods are not called.  Simply use
`MooseX::Role::WarnOnConflict' instead of `Moose::Role' and overriding a
role's method becomes a composition-time warning.  See the synopsis for a
resolution.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/M*

%changelog
