%define module_version 0.004
%define module_name MooseX-RoleQR
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Moose.pm) perl(Moose/Exporter.pm) perl(Moose/Role.pm) perl(MooseX/ClassAttribute.pm) perl(Scalar/Does.pm) perl(Test/More.pm) perl(namespace/sweep.pm) perl(thanks.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.004
Release: alt1.1
Summary: allow "before qr{...} => sub {...};" in roles
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/MooseX-RoleQR

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

Provides: perl(MooseX/RoleQR/Trait/Role.pm) = %version

%description
Method modifiers in Moose classes can be specified using regular expressions.a la:

   before qr{...} => sub {...};

However, this is not allowed in Moose roles because Moose doesn't know which
class the role will be composed with, and thus doesn't know which method
names match the regular expression. Let's change that.

This module implements regular expression matched method modifiers for Moose
roles. It does so by deferring the calculation of which methods to modify
until role application time.

The current implementation handles only `before', `after' and `around'
modifiers (not `override'), and thus it overrides the following standard
Moose::Role keywords:

=over

=item `before Str|ArrayRef|RegexpRef => CodeRef'

=item `after Str|ArrayRef|RegexpRef => CodeRef'

=item `around Str|ArrayRef|RegexpRef => CodeRef'

=back

=begin trustme

=item `init_meta'

=end trustme


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE COPYRIGHT README examples
%perl_vendor_privlib/M*

%changelog
