# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Time/HiRes.pm) perl(Time/Local.pm) perl(YAML.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    MooseX-Timestamp
%define upstream_version 0.07

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_11

Summary:    Simple timestamp type for Moose, with Time Zone
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        http://search.cpan.org/dist/%{upstream_name}
Source0:    http://www.cpan.org/modules/by-module/MooseX/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(inc/Module/Install.pm)
BuildRequires: perl(Memoize.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Sub/Exporter.pm)
BuildArch: noarch
Source44: import.info

%description
This module provides a timestamp type as a Str subtype for Moose. This is a
much more lightweight format than, say, the DateTime manpage, with the
disadvantage that it does not support native operations on the dates.

This module provides floating dates on the Gregorian calendar without much
code. It operates in (one or two particular variants of) ISO-8601 date
format, and POSIX-style 6-number lists.

Note: you probably want the functions provided by MooseX::TimestampTZ most
of the time, as they deal in unix epoch times.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make

%check
%make test

%install
%makeinstall_std

%files
%doc SIGNATURE META.yml Changelog
%perl_vendor_privlib/*




%changelog
