Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-MooseX-Types-DateTimeX
Version:        0.10
Release:        alt2_42
Summary:        Extensions to MooseX::Types::DateTime::ButMaintained
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/MooseX-Types-DateTimeX
Source0:        https://cpan.metacpan.org/authors/id/E/EC/ECARROLL/MooseX-Types-DateTimeX-%{version}.tar.gz
# https://rt.cpan.org/Public/Bug/Display.html?id=73467
Patch0:         MooseX-Types-DateTimeX-0.10-fix_subtypes.patch
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(inc/Module/Install.pm)
BuildRequires:  perl(Module/Install/AutoInstall.pm)
BuildRequires:  perl(Module/Install/Metadata.pm)
BuildRequires:  perl(Module/Install/WriteAll.pm)
# Run-time
BuildRequires:  perl(DateTime.pm)
BuildRequires:  perl(DateTime/Duration.pm)
BuildRequires:  perl(DateTimeX/Easy.pm)
BuildRequires:  perl(Moose.pm)
BuildRequires:  perl(MooseX/Types.pm)
BuildRequires:  perl(MooseX/Types/DateTime/ButMaintained.pm)
BuildRequires:  perl(namespace/clean.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Time/Duration/Parse.pm)
BuildRequires:  perl(warnings.pm)
# Tests only:
# perl(DateTime::Format::DateManip) missing in META.yml
BuildRequires:  perl(DateTime/Format/DateManip.pm)
BuildRequires:  perl(Test/Exception.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/use/ok.pm)
Requires:       perl(DateTimeX/Easy.pm) >= 0.085
Requires:       perl(Moose.pm) >= 0.410
Requires:       perl(MooseX/Types.pm) >= 0.040
Requires:       perl(MooseX/Types/DateTime/ButMaintained.pm) >= 0.040
Requires:       perl(namespace/clean.pm) >= 0.080
Requires:       perl(Time/Duration/Parse.pm) >= 0.060
Conflicts:      perl(MooseX/Types/DateTime.pm) < 0.050

# RPM 4.8 style:
%filter_from_requires /^perl.DateTimeX.Easy.pm.$/d
%filter_from_requires /^perl.MooseX.Types.DateTime.ButMaintained.pm.$/d
%filter_from_requires /^perl.namespace.clean.pm.$/d
%filter_from_requires /^perl.Time.Duration.Parse.pm.$/d

# RPM 4.9 style:




Source44: import.info

%description
This module builds on MooseX::Types::DateTime to add additional custom
types and coercions. Since it builds on an existing type, all coercions and
constraints are inherited.

%prep
%setup -q -n MooseX-Types-DateTimeX-%{version}
%patch0 -p1
# Remove bundled libraries
rm -r inc
sed -i -e '/^inc\// d' MANIFEST

%build
PERL5_CPANPLUS_IS_RUNNING=1 /usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -delete
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc Changes
%{perl_vendor_privlib}/*

%changelog
