# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Moose.pm) perl(YAML/Syck.pm) perl(YAML/XS.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    MooseX-YAML
%define upstream_version 0.05

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_3

Summary:    DWIM loading of Moose objects from YAML
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/MooseX/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(MooseX/Blessed/Reconstruct.pm)
BuildRequires: perl(Sub/Exporter.pm)
BuildRequires: perl(Test/use/ok.pm)
BuildRequires: perl(YAML.pm)
BuildRequires: perl(namespace/clean.pm)
BuildArch:  noarch
Source44: import.info

%description
This module provides DWIM loading of the Moose manpage based objects from
YAML documents.

Any hashes blessed into a the Moose manpage class will be replaced with a
properly constructed instance (respecting init args, 'BUILDALL', and the
meta instance type).

This is similar to the YAML::Active manpage in that certain nodes in the
loaded YAML documented are treated specially.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes META.json META.yml 
%perl_vendor_privlib/*

%changelog
