# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Morpheus
%define upstream_version 0.46

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_10

Summary:    Extra plugins - Env and File
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module//%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Config.pm)
BuildRequires: perl(DBI.pm)
BuildRequires: perl(Data/Dump.pm)
BuildRequires: perl(Data/Dumper.pm)
BuildRequires: perl(Digest/MD5.pm)
BuildRequires: perl(Exporter.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Find.pm)
BuildRequires: perl(Getopt/Long.pm)
BuildRequires: perl(JSON.pm)
BuildRequires: perl(Params/Validate.pm)
BuildRequires: perl(Pod/Usage.pm)
BuildRequires: perl(Symbol.pm)
BuildRequires: perl(Template.pm)
BuildRequires: perl(Test/Class.pm)
BuildRequires: perl(Test/Exception.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(XML/Simple.pm)
BuildRequires: perl(base.pm)
BuildRequires: perl(overload.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
Morpheus is a configuration engine that completely separates config
consumers from config providers.

Consumers can obtain configuration values by using this module or the morph
manpage script. Configuration values are binded to various nodes in the
global config tree, similar to virtual file system. Consumers can ask for
any node or for any subtree.

Providers are plugins which can populate configuration tree from any
sources: local configuration files, configuration database, environment,
etc. The overall program configuration is merged together from all data
provided by plugins.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.yml  README
%perl_vendor_privlib/*
/usr/bin/morph
%{_mandir}/man1/morph.1*

%changelog
