%define module_name Museum-MetropolitanMuseumArt
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(JSON/MaybeXS.pm) perl(LWP.pm) perl(Moo.pm) perl(Test/More.pm) perl(URI.pm) perl(namespace/clean.pm) perl(strictures.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: A simple interface to the Metropolitan Museum of Art's API
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RS/RSHEAT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Provides access to the object-related endpoints from the Metropolitan Museum's
API. See https://metmuseum.github.io/#objects for the API information.

    use Museum::MetropolitanMuseumArt;

    my $m = Museum::MetropolitanMuseumArt->new();
    # Returns an arrayref of IDs. Dies if there's an error.
    my $new_objects->$m->get_objects(date => '2023-01-01');
    if (@$new_objects) {
        # A hashref containing the object data
        my $object = $m->get_object($new_objects->[0]);
        say $object->{title};
    }

Note: The Met Museum requests a rate-limit of 80 requests per second,
please stick to that.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_privlib/M*

%changelog
