%define module_name Music-Bassline-Generator
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dumper/Compact.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(List/SomeUtils.pm) perl(List/Util.pm) perl(Moo.pm) perl(Music/Chord/Note.pm) perl(Music/Note.pm) perl(Music/PitchNum.pm) perl(Music/Scales.pm) perl(Music/VoiceGen.pm) perl(Pod/Coverage/TrustPod.pm) perl(Pod/Wordlist.pm) perl(Set/Array.pm) perl(Test/EOL.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Spelling.pm) perl(Test/Synopsis.pm) perl(Try/Tiny.pm) perl(constant.pm) perl(namespace/clean.pm) perl(strict.pm) perl(strictures.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0608
Release: alt1
Summary: Generate musical basslines
Group: Development/Perl
License: artistic_2
URL: https://github.com/ology/MIDI-Bassline-Walk

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GE/GENE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`Music::Bassline::Generator' generates randomized, walking basslines.

Chords and the key use `#' and `b' for accidentals.

The "formula" implemented by this module is basically: "Play any notes
of the chord, modal chord scale, or chord-root scale (and drop any
notes replaced by extended jazz chords)."

The chords recognized by this module, are those known to
the Music::Chord::Note manpage.  Please see the source of that module for the
list.

The logic and music theory implemented here, can generate some
possibly sour notes.  This is an approximate composition tool, and not
a drop-in bass player.  Import rendered MIDI into a DAW and alter
notes until they sound suitable.

To constrain the notes to a chosen set of scale dregrees, use the
positions attribute described below.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes README.md
%perl_vendor_privlib/M*

%changelog
