%define module_version 0.65
%define module_name Music-Chord-Positions
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(Music/AtonalUtil.pm) perl(Music/Chord/Note.pm) perl(Test/More.pm) perl(Try/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.65
Release: alt1
Summary: generate various chord inversions and voicings
Group: Development/Perl
License: artistic_2
URL: http://github.com/thrig/Music-Chord-Positions

Source0: http://cpan.org.ua/authors/id/J/JM/JMATES/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Utility methods for generating tonal inversions or chord voicing
variations of a given pitch set. A pitch set is an array reference
consisting of semitone intervals:

  [0, 4, 7]      # Major      C  E  G
  [0, 3, 7]      # minor      C  D# G
  [0, 4, 7, 11]  # Major 7th  C  E  G  B

The pitch set may be specified manually, or the chord_num method of
the Music::Chord::Note manpage used to derive a pitch set from a named chord.

  use Music::Chord::Note;
  use Music::Chord::Positions;

  # These both result in the same output from chord_inv()
  my $i1 = chord_inv([ 0,3,7                                   ]);
  my $i2 = chord_inv([ Music::Chord::Note->new->chord_num('m') ]);

This module pays attention to the vertical spacing of notes.
Pitches are integers from 0 up, a semitone per integer, and the
octave at 12 semitones (unless scale_degrees is customized to
some non-12-tone system).

Consult the `eg' directory for example scripts.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/M*

%changelog
