# BEGIN SourceDeps(oneline):
BuildRequires: perl(List/Util.pm) perl(List/UtilsBy.pm) perl(Module/Build.pm) perl(Moo.pm) perl(Music/PitchNum.pm) perl(Music/Scales.pm) perl(Test2/V0.pm) perl(namespace/clean.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_name Music-Guidonian
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: a "Guidonian Hand" melodic phrase generator
Group: Development/Perl
License: bsd
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JM/JMATES/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
"Guido of Arezzo" is credited with the creation of the "Guidonian Hand"
which grew into among other things a method to aid with the creation of
new music. This implementation is based off of a description of the
process found in "Musimathics" (Volume 1, Chapter 9). In brief, pitches
in a given ambitus are keyed to particular letters, usually vowels
repeated over some sequence of intervals (a scale). Then, given a
sequence of those particular letters, a sequence of pitch numbers is
returned for each call to an iterator function until no more
possibilities remain, or, more likely for longer phrases, the caller
gives up having found something suitable (or perhaps aborts early).
Pitch numbers may be included in the input sequence to lock those
positions to the given pitches.

Pitches are integers, typically MIDI numbers. These may need to be
confined to a particular range (the ambitus) of values. Keys could be
any scalar value (though integers would be a bad choice) and typically
will be the vowels of a text phrase that is to be set to music. The
caller may need to manually or otherwise process the a phrase to extract
the vowels or whatever keys are being used.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/M*

%changelog
