%define module_version 0.09
%define module_name Music-PitchNum
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Moo/Role.pm) perl(Scalar/Util.pm) perl(Test/Most.pm) perl(lib.pm) perl(strict.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt1
Summary: note name and pitch number utility roles
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JM/JMATES/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
=over 4

"One need but glance at the various notations for a single tone to be convinced
that there is a sorrowful lack of agreement in usage." -- R. W. Young.
"Terminology for Logarithmic Frequency Units"

=back

This module provides utility music pitch name and number routines; that is, an
easy way to obtain pitch numbers from various pitch name formats (Helmholtz, or
in particular what `lilypond' uses, what the MIDI::Simple manpage accepts, and the
American Standard Pitch Notation (ASPN)). The resulting pitch numbers are
integers (as used by the MIDI standard), though this module does not restrict
the range of the pitch numbers as MIDI does (support for black hole pressure
waves was a design goal).

This module is somewhat catholic in what it accepts; alternatives are the
variety of sub-modules that support only the named notation system; the
the Music::PitchNum::German manpage implementation, in particular, is Helmholtz-based,
though with "H" representing B natural and "B" as B flat as is necessary for
BACH motif support. Not supported by this particular module include the ABC
notation, solfege note names, and various other International formats. There is
also no microtonal support, and the traditional Western 12-tone chromatic scale
is used as the basis for the resulting pitch numbers. Also, the parsing of the
notes is limited to just the note name, octave indication, and accidental, and
in no way supports rhythmic elements or the like.

This module is expected to be used as a Role from some other module;
the Moo::Role manpage may be informative.
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/M*

%changelog
