%define module_name MySQL-Easy
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/mysql.pm) perl(DBI.pm) perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(common/sense.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.1019
Release: alt2
Summary: Perl extension to handle various mundane DBI session related things specific to mysql.
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JE/JETTERO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
I don't remember how I used to live without this...  I do like the way the DBI manpage
and the DBD::mysql manpage work, but I wanted something *slightly* prettier...
*slightly* handier.

Here are the functions the MySQL::Easy manpage provides:

=over

=item new

    $dbo = MySQL::Easy->new( $db_name, $trace )

`$db_name' is the name of the database you're connecting to...  If you don't
pick anything, it'll pick "test" for you.  `$trace' is a 1 or false, ... it's
the DBI->trace() ...

    $dbo = MySQL::Easy->new( $db_name, {user=>"blarg", host=>"whatever"})

Alternatively, you can pass a hashref of options in place of the trace argument.
Passing `user=>"blarg"' in this way is the same as calling
`$dbo->set_user()' -- so this is really only good for avoiding calls to
`set_user', `set_pass', and `set_host'; although, `trace' also works as an
attribute here by calling the function of the same name.

=item do

    $dbo->do("sql statement bind=? bind=?", $bind1, $bind2);

This immediately executes the SQL with the bind vars given.  You can pas in a
statement handle instead of the string... this is faster if you're going to use
the SQL over and over.  Returns a bool like you'd expect.  Example:

    $dbo->do("stuff");

=item lock

    $dbo->lock("table1", "table2", "table3");

    # code

    $dbo->unlock;

the MySQL::Easy manpage uses only write locks.  Those are the ones where nobody can read
or write to the table except the locking thread.  If you need a read lock, let
me know.  Most probably though, if you're using this, it's a smaller app, and it
doesn't matter anyway.

=item ready

   $sth = $dbo->ready("Sql Sql Sql=? and Sql=?");
   $sth->execute($bindvar);
   $sth->fetchrow_hashref; # etc...

`ready()' returns a DBI statement handle,
mostly.  The the MySQL::Easy manpage statement handles automatically recover from
disconnects.  At the time of this writing, the DBI manpage statement handles do not do
this (although the database handle does).

=item firstcol

   $arr = $dbo->firstcol("select col from tab w...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/M*

%changelog
