%define module_name NBI-Slurm
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Capture/Tiny.pm) perl(Carp.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(JSON/PP.pm) perl(PerlIO/encoding.pm) perl(Pod/Usage.pm) perl(Storable.pm) perl(Term/ANSIColor.pm) perl(Text/ASCIITable.pm) perl(Time/Piece.pm) perl(Time/Seconds.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.12.0
Release: alt1
Summary: NBI Slurm module
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PR/PROCH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The `NBI::Slurm' package provides a set of classes and methods for submitting jobs to SLURM, a workload manager for high-performance computing (HPC) clusters. It includes the the NBI::Job manpage and `NBI::Opts' classes, which allow you to define and configure jobs to be submitted to SLURM.

The the NBI::Job manpage class represents a job to be submitted to SLURM. 
It provides methods for setting the job name, defining the commands to be executed, setting the output and error file paths, and submitting the job to SLURM. 

The the NBI::Opts manpage class represents the SLURM options for the job, such as the queue, number of threads, allocated memory, and execution time. It allows you to configure these options and generate the SLURM header for the job script.

By combining the NBI::Job and NBI::Opts classes, you can easily create and submit jobs to SLURM. 
The `NBI::Slurm' package provides a convenient interface for interacting with SLURM and managing HPC jobs.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes README.md LICENSE docs
%perl_vendor_privlib/N*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
