%define module_version 0.10
%define module_name NanoMsg-Raw
# BEGIN SourceDeps(oneline):
BuildRequires: libnanomsg-devel perl(CPAN/Meta.pm) perl(Devel/CheckLib.pm) perl(Encode.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Tiny.pm) perl(JSON.pm) perl(Module/Metadata.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/EOL.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/SharedFork.pm) perl(Test/TCP.pm) perl(Time/HiRes.pm) perl(XSLoader.pm) perl(overload.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt9
Summary: Low-level interface to the nanomsg scalability protocols library
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BO/BORISZ/%{module_name}-%{module_version}.tar.gz

%description
`NanoMsg::Raw' is a binding to the `nanomsg' C library. The goal of this
module is to provide a very low-level and manual interface to all the
functionality of the nanomsg library. It doesn't intend to provide a convenient
high-level API, integration with event loops, or the like. Those are intended to
be implemented as separate abstractions on top of `NanoMsg::Raw'.

The nanomsg C library is a high-performance implementation of several
"scalability protocols". Scalability protocol's job is to define how multiple
applications communicate to form a single distributed
application. Implementation of following scalability protocols is available at
the moment:

=for :list
* `PAIR'
simple one-to-one communication
* `BUS'
simple many-to-many communication
* `REQREP'
allows one to build clusters of stateless services to process user requests
* `PUBSUB'
distributes messages to large sets of interested subscribers
* `PIPELINE'
aggregates messages from multiple sources and load balances them among many
destinations
* `SURVEY'
allows one to query state of multiple applications in a single go

Scalability protocols are layered on top of transport layer in the network
stack. At the moment, nanomsg library supports following transports:

=for :list
* `INPROC'
transport within a process (between threads, modules etc.)
* `IPC'
transport between processes on a single machine
* `TCP'
network transport via TCP

=func nn_socket($domain, $protocol)

    my $s = nn_socket(AF_SP, NN_PAIR);
    die nn_errno unless defined $s;

Creates a nanomsg socket with specified `$domain' and `$protocol'. Returns a
file descriptor for the newly created socket.

Following domains are defined at the moment:

=for :list
* `AF_SP'
Standard full-blown SP socket.
* `AF_SP_RAW'
Raw SP socket. Raw sockets omit the end-to-end functionality found in `AF_SP'
sockets and thus can be used to implement intermediary devices in SP topologies.

The `$protocol' parameter defines the type of the socket, which in turn
determines the exact semantics of the socket...
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_archlib/N*
%perl_vendor_autolib/*

%changelog
