# BEGIN SourceDeps(oneline):
BuildRequires: perl(DateTime.pm) perl(DateTime/Format/ISO8601.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Neovim/RPC/Plugin.pm) perl(Promises.pm) perl(Taskwarrior/Kusarigama/Wrapper.pm) perl(Test/More.pm) perl(experimental.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Neovim-RPC-Plugin-Taskwarrior
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0.1
Release: alt1
Summary: UI for taskwarrior
Group: Development/Perl
License: perl
URL: https://github.com/yanick/Neovim-RPC-Plugin-Taskwarrior

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/Y/YA/YANICK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This plugin needs a few things to work.

First, `nvim' must be configured to use the Neovim::RPC manpage (duh).

Then configure nvim to use the vim side of this plugin as well as
TableMode. I use `Plugged', and  my configuration looks like:

    Plug 'yanick/Neovim-RPC-Plugin-Taskwarrior'
    Plug 'dhruvasagar/vim-table-mode', {
        \ 'on': [ 'TableModeEnable' ]
    \ }

Once all of that is done, you can invoke the taskwarrior UI via
`:Task'. Or straight from the command-line as 

    $ nvim -c 'call Task()'

The plugin has a slew of commands built-in. Right now,
if you want to change the aliases, just go and dive in
taskwarrior.vim.

    | command    | mode           | description                                |
    | ----       | ---            | ---                                        |
    | <leader>d  | normal, visual | mark task(s) as done                       |
    | <leader>D  | normal, visual | delete task(s)                             |
    | <leader>ll | normal         | show all +PENDING tasks                    |
    | <leader>lf | normal         | show all +focus tasks                      |
    | <leader>lq | normal         | show tasks, prompt for filter              |
    | <leader>m  | normal, visual | mod task(s), prompt for modification       |
    | <leader>m  | normal, visual | append to task(s), prompt for modification |
    | <leader>i  | normal, visual | show info for task(s)                      |
    | <leader>ph | normal, visual | set priority of task(s) to be high         |
    | <leader>pm | normal, visual | set priority of task(s) to be medium       |
    | <leader>pl | normal, visual | set priority of task(s) to be low          |
    | <leader>W  | normal, visual | set 'wait' for task(s)                     |

The plugin will set the buffer listing the tasks as  a file of type `task'.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.mkdn LICENSE AUTHOR_PLEDGE CONTRIBUTORS
%perl_vendor_privlib/N*

%changelog
