# BEGIN SourceDeps(oneline):
BuildRequires: perl(Call/Context.pm) perl(Crypt/Format.pm) perl(Crypt/Perl.pm) perl(Digest/SHA.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(HTTP/Tiny.pm) perl(HTTP/Tiny/UA/Response.pm) perl(JSON.pm) perl(MIME/Base64.pm) perl(Test/Class.pm) perl(Test/Deep.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/NoWarnings.pm) perl(Test/Simple.pm) perl(autodie.pm) perl(constant.pm) perl(parent.pm) perl(use.pm)
# END SourceDeps(oneline)
%define module_name Net-ACME
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.17
Release: alt1
Summary: Client for the (old) ACME protocol (e.g., L<Let.s Encrypt|http://letsencrypt.org>)
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/F/FE/FELIPE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module implements client logic (including SSL certificate issuance)
for the .e'draft.e' version of the ACME protocol,
the system for automated issuance of SSL certificates used by
Let.e's Encrypt.

For support of the IETF-standard version of this
protocol, look at the Net::ACME2 manpage.

The methods of this class return objects that correspond to the
respective ACME resource:

=over 4

=item * `register()': `Net::ACME::Registration'

=item * `start_domain_authz()': `Net::ACME::Authorization::Pending'

=item * `get_certificate()': `Net::ACME::Certificate' or `Net::ACME::Certificate::Pending'

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE examples
%perl_vendor_privlib/N*

%changelog
