# BEGIN SourceDeps(oneline):
BuildRequires: perl(Array/Iterator.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(File/Temp.pm) perl(HTTP/Headers.pm) perl(HTTP/Request/Common.pm) perl(JSON.pm) perl(LWP.pm) perl(LWP/Protocol/https.pm) perl(LWP/UserAgent.pm) perl(Module/Build.pm) perl(Moo.pm) perl(MooX/Types/MooseLike.pm) perl(MooX/Types/MooseLike/Base.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Sub/Quote.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 1.06
%define module_name Net-API-Gett
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.06
Release: alt1
Summary: Perl bindings for Ge.tt API
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MA/MALLEN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
use 5.010;
    use Net::API::Gett;

    # Get API Key from http://ge.tt/developers

    my $gett = Net::API::Gett->new( 
        api_key      => 'GettAPIKey',
        email        => 'me@example.com',
        password     => 'mysecret',
    );

    my $file_obj = $gett->upload_file( 
        filename => "ossm.txt",
        contents => "/some/path/example.txt",
           title => "My Awesome File", 
        encoding => ":encoding(UTF-8)" 
    );

    say "File has been shared at " . $file_obj->getturl;

    # Download contents
    my $file_contents = $file_obj->contents();

    open my $fh, ">:encoding(UTF-8)", "/some/path/example-copy.txt" 
        or die $!;
    print $fh $file_contents;
    close $fh;

    # clean up share and file(s)
    my $share = $gett->get_share($file->sharename);
    $share->destroy();


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/N*

%changelog
