%define module_name Net-AS2-PSGI
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request/Common.pm) perl(JSON/XS.pm) perl(Net/AS2.pm) perl(Net/SSLeay.pm) perl(Plack/Builder.pm) perl(Plack/Request.pm) perl(Plack/Test.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(autodie.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0001
Release: alt1
Summary: AS2 Protocol Plack application
Group: Development/Perl
License: perl
URL: https://github.com/andrewjmaguire/Net-AS2-PSGI

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AJ/AJM/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module defines an AS2 Protocol compliant Plack application.

The AS2 Protocol is specified by RFC 4130. This protocol defines a
secure peer-to-peer data transfer with receipt using HTTP. The receipt
is called a Message Disposition Notification (MDN) and is specified by
RFC 3798.

The Public certificates between each partnership are exchanged
independently. i.e. The AS2 protocol does not allow for the public
certificate to be downloaded, they must be exchanged before any AS2
communication can occur.

Implementations of the AS2 Protocol extend the original RFC 4130 to
allow for transfer over HTTPS and use of newer signing algorithms,
e.g. the SHA-2 family.

The AS2 Protocol defines two modes, Synchronous and Asynchronous.

The supported AS2 Protocol version is 1.0. Version 1.1 (compression)
is not supported.

=over 4

=item Synchronous

In this mode the data is POSTed from the sender to the receiver and
the response is the MDN receipt.

=item Asynchronous

In this mode the data is POSTed from the sender to the receiver but
the response only confirms the data was sent.

The receiver on completion of receiving the data, POSTs the MDN
receipt for the data back to the sender.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md LICENSE README examples
%perl_vendor_privlib/N*

%changelog
