Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(BerkeleyDB/Manager.pm) perl(Path/Class.pm) perl(Perl6/Say.pm) perl(Pod/Usage.pm) perl(Set/Object.pm) perl(Term/Encoding.pm) perl(Term/ProgressBar/Simple.pm) perl(Test/EOL.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:       perl-Net-Amazon-S3
Version:    0.991
Release:    alt1_7
Summary:    Use the Amazon Simple Storage Service (S3)
# README.md reports the code is derived from an ADSL-licensed code.
License:    (GPL-1.0-or-later OR Artistic-1.0-Perl) AND ADSL
URL:        https://metacpan.org/release/Net-Amazon-S3
Source0:    https://cpan.metacpan.org/authors/id/B/BA/BARNEY/Net-Amazon-S3-%{version}.tar.gz
# Fix shebang
Patch0:     Net-Amazon-S3-0.86-Normalize-shellbang.patch
# Fix a content type check in multi-part upload, in upstream after 0.991,
# <https://github.com/rustyconover/net-amazon-s3/issues/124>
Patch1:     Net-Amazon-S3-0.991-Fix-initiate_multipart_upload-content-type-check.patch
BuildArch:  noarch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time:
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Data/Stream/Bulk/Callback.pm)
BuildRequires:  perl(DateTime/Format/HTTP.pm)
BuildRequires:  perl(Digest/HMAC_SHA1.pm)
BuildRequires:  perl(Digest/MD5.pm)
BuildRequires:  perl(Digest/MD5/File.pm)
BuildRequires:  perl(Digest/SHA.pm)
BuildRequires:  perl(Exporter/Tiny.pm)
BuildRequires:  perl(File/Find/Rule.pm)
BuildRequires:  perl(File/stat.pm)
# Getopt::Long not used at tests
BuildRequires:  perl(Hash/Util.pm)
BuildRequires:  perl(HTTP/Date.pm)
BuildRequires:  perl(HTTP/Response.pm)
BuildRequires:  perl(HTTP/Status.pm)
BuildRequires:  perl(IO/File.pm)
# LWP 6.03 needed indirectly to support 100 Continue HTTP response
BuildRequires:  perl(LWP.pm)
# HTTPS required because "secure" attribute is enabled by default
# LWP::Protocol::https not used at tests
BuildRequires:  perl(LWP/UserAgent/Determined.pm)
BuildRequires:  perl(MIME/Base64.pm)
BuildRequires:  perl(MIME/Types.pm)
BuildRequires:  perl(Moose.pm)
BuildRequires:  perl(Moose/Meta/Class.pm)
BuildRequires:  perl(Moose/Object.pm)
BuildRequires:  perl(Moose/Role.pm)
BuildRequires:  perl(Moose/Util.pm)
BuildRequires:  perl(Moose/Util/TypeConstraints.pm)
BuildRequires:  perl(MooseX/Role/Parameterized.pm)
BuildRequires:  perl(MooseX/StrictConstructor.pm)
BuildRequires:  perl(MooseX/Types/DateTime/MoreCoercions.pm)
BuildRequires:  perl(namespace/clean.pm)
BuildRequires:  perl(parent.pm)
# Path::Class not used at tests
# Pod::Usage not used at tests
BuildRequires:  perl(Ref/Util.pm)
BuildRequires:  perl(Regexp/Common.pm)
BuildRequires:  perl(Safe/Isa.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(sort.pm)
BuildRequires:  perl(Sub/Override.pm)
# Term::Encoding is optional
# Term::ProgressBar::Simple not used at tests
BuildRequires:  perl(Test/Deep.pm)
BuildRequires:  perl(Test/LWP/UserAgent.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Time/Piece.pm)
BuildRequires:  perl(URI.pm)
BuildRequires:  perl(URI/Escape.pm)
BuildRequires:  perl(URI/QueryParam.pm)
BuildRequires:  perl(VM/EC2/Security/CredentialCache.pm)
BuildRequires:  perl(XML/LibXML.pm)
BuildRequires:  perl(XML/LibXML/XPathContext.pm)
# Tests:
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(FindBin.pm)
BuildRequires:  perl(HTTP/Request.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(LWP/Simple.pm)
BuildRequires:  perl(Test/Exception.pm)
BuildRequires:  perl(Test/MockTime.pm)
BuildRequires:  perl(Test/Warnings.pm)
BuildRequires:  perl(utf8.pm)
BuildRequires:  perl(vars.pm)
# LWP 6.03 needed indirectly to support 100 Continue HTTP response
Requires:       perl(LWP.pm) >= 6.030
# HTTPS required because "secure" attribute is enabled by default
Requires:       perl(LWP/Protocol/https.pm)
Requires:       perl(VM/EC2/Security/CredentialCache.pm)
# Provide modules loaded by a different file name, bug #1892877
Provides:       perl(Net/Amazon/S3/Operation/Object/Upload/Part.pm) = %{version}
Provides:       perl(Net/Amazon/S3/Operation/Object/Upload/Parts.pm) = %{version}
Provides:       perl(Net/Amazon/S3/Operation/Objects/Delete.pm) = %{version}
Provides:       perl(Net/Amazon/S3/Operation/Objects/List.pm) = %{version}

# Filter under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(Test.Deep.pm)/d

%description
This module provides a Perlish interface to Amazon S3. From the
developer blurb: "Amazon S3 is storage for the Internet. It is designed
to make web-scale computing easier for developers. Amazon S3 provides a
simple web services interface that can be used to store and retrieve any
amount of data, at any time, from anywhere on the web. It gives any
developer access to the same highly scalable, reliable, fast,
inexpensive data storage infrastructure that Amazon uses to run its own
global network of web sites. The service aims to maximize benefits of
scale and to pass those benefits on to developers".

To find out more about S3, please visit <http://s3.amazonaws.com/>.

%package -n perl-Shared-Examples-Net-Amazon-S3
Group: Development/Other
Summary:    Example modules for Net::Amazon::S3 Perl tool kit
Requires:   perl-Net-Amazon-S3 = %{version}-%{release}
Requires:   perl(Test/Deep.pm) >= 0.111

%description -n perl-Shared-Examples-Net-Amazon-S3
This package is an executable documentation for Net::Amazon::S3 Perl tool kit.

%package tests
Group: Development/Other
Summary:        Tests for %{name}
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}
Requires:       perl(Test/Deep.pm) >= 0.111

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n Net-Amazon-S3-%{version}
%patch0 -p1
%patch1 -p1

# Get rid of unnecessary executable bits
find lib -name '*.pm' -exec chmod -c -x {} +
# Remove author tests
rm t/author-eol.t
perl -i -ne 'print $_ unless m{\A\Qt/author-eol.t\E}' MANIFEST
# Help generators to recognize a Perl code
for F in t/*.{t,pl}; do
    perl -i -MConfig -pe 'print qq{$Config{startperl}\n} if $. == 1 && !s{\A#!.*\bperl}{$Config{startperl}}' "$F"
    chmod +x "$F"
done

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}
# Install tests
mkdir -p %{buildroot}%{_libexecdir}/%{name}
cp -a t %{buildroot}%{_libexecdir}/%{name}
cat > %{buildroot}%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/sh
unset AMAZON_S3_EXPENSIVE_TESTS AWS_ACCESS_KEY_ID
cd %{_libexecdir}/%{name} && exec prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
EOF
chmod +x %{buildroot}%{_libexecdir}/%{name}/test

%check
unset AMAZON_S3_EXPENSIVE_TESTS AWS_ACCESS_KEY_ID
export HARNESS_OPTIONS=j$(perl -e 'if ($ARGV[0] =~ /.*-j([0-9][0-9]*).*/) {print $1} else {print 1}' -- '%{?_smp_mflags}')
make test

%files
%doc --no-dereference LICENSE
# README.mkdn does not contain anything new
%doc CHANGES README README.md
%{_bindir}/s3cl
%dir %{perl_vendor_privlib}/Net
%dir %{perl_vendor_privlib}/Net/Amazon
%{perl_vendor_privlib}/Net/Amazon/S3
%{perl_vendor_privlib}/Net/Amazon/S3.pm
%{_mandir}/man1/s3cl.*

%files -n perl-Shared-Examples-Net-Amazon-S3
%dir %{perl_vendor_privlib}/Shared
%dir %{perl_vendor_privlib}/Shared/Examples
%dir %{perl_vendor_privlib}/Shared/Examples/Net
%dir %{perl_vendor_privlib}/Shared/Examples/Net/Amazon
%{perl_vendor_privlib}/Shared/Examples/Net/Amazon/S3
%{perl_vendor_privlib}/Shared/Examples/Net/Amazon/S3.pm

%files tests
%{_libexecdir}/%{name}

%changelog
