%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request.pm) perl(HTTP/Response.pm) perl(Net/Analysis.pm) perl(Net/Analysis/Constants.pm) perl(Net/Analysis/Dispatcher.pm) perl(Net/Analysis/EventLoop.pm) perl(Net/Analysis/Listener/Base.pm) perl(Net/Analysis/Listener/HTTP.pm) perl(Net/Analysis/Listener/TCP.pm) perl(Net/Analysis/Time.pm) perl(Params/Validate.pm) perl(PostScript/Simple.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Net-Analysis-Listener-HTTPClientPerf
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: analysis of client performance
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/W/WO/WORRALL/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
We listen to the `http_transaction' events, and build up a data structure
designed for a graphical report.

Each time we see `tcp_sesssion_start', we start up a new session box. In this
box, we build a packet histogram over time, as `tcp_packet' events are seen.
The `tsnap' setting defines the time window; any packets for that session that
flow within the window are added together. At the end, each window will contain
a count of the packets, and also counts for the different classes (data vs.
duplicates vs. non-data, etc).

As we see `http_transaction' events, we classify them based on their headers.
A record of the times, and class, of each transaction is added to the session
box.

When the session box is closed, we run through the various histograms, and
assign each set of counters a HTTP classification based on which http
transaction event their time lies within (e.g. request, response). We then run
through the http transaction list and insert req_start,req_stop, resp_start,
and resp_stop timings into the histogram sequence.

At this point, for each session we now have a time-ordered sequence of http
event timings, and fully classified packet histograms.

We now do a quick check over all the session boxes, to get scales for the axes.
Horiztonal is time; vertical is number of packets. We draw the axes, and also
any relevant graph furniture.

Then draw all the boxes. Sessions are stacked where they are concurrent; else
they are fitted in, to give a sense of the number of concurrent sessions that
were used during the request.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc TODO Changes README
%perl_vendor_privlib/N*

%changelog
