# BEGIN SourceDeps(oneline):
BuildRequires: perl(Net/Jabber.pm) perl(Net/Jabber/JID.pm) perl(Test/More.pm) perl(Time/HiRes.pm)
# END SourceDeps(oneline)
%define module_version 0.3
%define module_name Net-Chat-Daemon
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.3
Release: alt1
Summary: run a daemon that is controlled via instant messaging
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SF/SFINK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
package My::Server;
  use base 'Net::Chat::Daemon';
  sub handleHello {
    return "hello to you too";
  }
  sub handleSave {
    my ($filename, $file) = @_;
    return "denied" unless $filename =~ /^[.\w]+$/;
    open(my $fh, ">/var/repository/$filename") or return "failed: $!";
    print $fh $file;
    close $fh or return "failed: $!";
    return "ok";
  }
  sub someMethod {
    my ($self, @args) = @_;
    .
    .
    .
  }
  sub new {
    my ($class, $user, %%options) = @_;
    return $class->SUPER::new(%%options,
                              commands => { 'callMethod' => 'someMethod',
                                            'save' => \&handleSave });
  }

  package main;
  my $server = My::Server->new('myuserid@jabber.org');
  $server->process();

  # or to do it all in one step, and retry connections for 5 minutes
  # (300 seconds) before failing due to problems reaching the server:

  My::Server->run('myuserid@jabber.org', retry => 300);

When you run this, you should be able to send a message to
userid@jabber.org saying "hello" and get a response back, or
"callMethod a b c" to call the method with the given arguments. To use
the "save" command, you'll need to use a command-line client capable
of sending attachments in the format expected by this server (it
currently does not use any standard file-sending formats). The
`jabber' command packaged with this module can do this via the `-a'
command-line option.

A note on the implementation: when I first wrote this, it was really
only intended to be used with Jabber. The code hasn't been fully
restructured to remove this assumption.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/N*

%files scripts
%_bindir/*

%changelog
