%define module_name Net-Cloudflare-DNS
# BEGIN SourceDeps(oneline):
BuildRequires: perl(JSON.pm) perl(LWP/Protocol/https.pm) perl(LWP/UserAgent.pm) perl(URI.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.21
Release: alt1
Summary: DNS API for Cloudflare API v4
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/W/WE/WESLEY/%{module_name}-%{version}.tgz
BuildArch: noarch

%description
Cloudflare API v4 has big improvement to the older ones. This API operates against the specific zone based on API v4. 

I use this module to dyna update my DNS zone everyday. Cloudflare's DNS and its API behave very well in my life.

If you have met any issue with the module, please don't hesitate to drop me an email: iwesley [at] pobox.com

To use the module, you must have these two perl modules installed in the system:

    sudo apt install libio-socket-ssl-perl
    sudo cpanm LWP::Protocol::https

My system is Ubuntu, which can use apt to install IO::Socket::SSL. I can't install this module with cpanm tool.

    use Net::Cloudflare::DNS;

    # new the object
    my $dns = Net::Cloudflare::DNS->new(email=>$email, api_key=>$api_key, zone_id=>$zone_id);

    # create the record
    my $res = $dns->create_record(type=>"A", name=>"test.myhostnames.com",content=>"1.1.1.1",ttl=>1);

    # update the record
    $res = $dns->update_record($record_id, type=>"TXT", name=>"test.myhostnames.com",content=>"bala bala",ttl=>1);

    # delete the record
    $res = $dns->delete_record($record_id);

    # list records by conditions
    $res = $dns->get_records(name=>"test.myhostnames.com");

    # if the method succeed, a structure reference was returned, whose content is response content from cloudflare 
    # otherwise the method just dies, you should catch the error in your code
    use Data::Dumper;
    print Dumper $res;

Hence this is my own script for test purpose:

    use strict;
    use warnings;
    use Net::Cloudflare::DNS;

    my $obj = Net::Cloudflare::DNS->new(email    => $ENV{'CLOUDFLARE_EMAIL'},
                                        api_key  => $ENV{'CLOUDFLARE_API_KEY'},
                                        zone_id  => $ENV{'CLOUDFLARE_ZONE_ID'},
                                       );

    #
    # batch add
    #
    for (1..10) {
        my $rand_hostname = int(rand(3333333)) . ".myhostnames.com";
        my $rand_ip = int(rand(255)) ."." . int(rand(255)). ".". int(rand(255)). ".". int(rand(2...

%prep
%setup -q -n %{module_name}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes ignore.txt README
%perl_vendor_privlib/N*

%changelog
